/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.eap.cloudsdk;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DNSResolver {
    private static final Logger logger = LoggerFactory.getLogger(DNSResolver.class);

    public static InetAddress[] getAddresses(final String domain) throws UnknownHostException {
        ExecutorService executorService = Executors.newFixedThreadPool(1);
        Future<InetAddress[]> future = executorService.submit(new Callable<InetAddress[]>(){

            @Override
            public InetAddress[] call() throws Exception {
                return InetAddress.getAllByName(domain);
            }
        });
        executorService.shutdown();
        InetAddress[] addresses = null;
        try {
            addresses = future.get();
        }
        catch (InterruptedException e) {
            logger.warn(e.toString(), (Throwable)e);
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable != null && throwable instanceof UnknownHostException) {
                throw (UnknownHostException)throwable;
            }
            logger.warn(e.toString(), (Throwable)e);
        }
        if (addresses == null) {
            throw new UnknownHostException("Failed to parse domain:" + domain);
        }
        return addresses;
    }
}

